/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains;

import com.github.legoatoom.connectiblechains.chain.ChainLink;
import com.github.legoatoom.connectiblechains.chain.ChainType;
import com.github.legoatoom.connectiblechains.chain.ChainTypesRegistry;
import com.github.legoatoom.connectiblechains.compat.BuiltinCompat;
import com.github.legoatoom.connectiblechains.config.ModConfig;
import com.github.legoatoom.connectiblechains.enitity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.enitity.ChainLinkEntity;
import com.github.legoatoom.connectiblechains.enitity.ModEntityTypes;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectibleChains
implements ModInitializer {
    public static final String MODID = "connectiblechains";
    public static final Logger LOGGER = LogManager.getLogger((String)"ConnectibleChains");
    public static ModConfig fileConfig;
    public static ModConfig runtimeConfig;

    public void onInitialize() {
        ModEntityTypes.init();
        ChainTypesRegistry.init();
        BuiltinCompat.init();
        AutoConfig.register(ModConfig.class, Toml4jConfigSerializer::new);
        ConfigHolder configHolder = AutoConfig.getConfigHolder(ModConfig.class);
        fileConfig = (ModConfig)configHolder.getConfig();
        runtimeConfig = new ModConfig().copyFrom(fileConfig);
        UseBlockCallback.EVENT.register(ConnectibleChains::chainUseEvent);
        ServerPlayConnectionEvents.INIT.register((handler, server) -> fileConfig.syncToClient(handler.method_32311()));
    }

    private static class_1269 chainUseEvent(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (player == null || player.method_5715()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        class_2338 blockPos = hitResult.method_17777();
        class_2680 blockState = world.method_8320(blockPos);
        if (!ChainKnotEntity.canAttachTo(blockState)) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            class_1792 handItem = player.method_5998(hand).method_7909();
            if (ChainTypesRegistry.ITEM_CHAIN_TYPES.containsKey(handItem)) {
                return class_1269.field_5812;
            }
            if (ChainKnotEntity.getHeldChainsInRange(player, blockPos).size() > 0) {
                return class_1269.field_5812;
            }
            if (ChainKnotEntity.getKnotAt(player.field_6002, blockPos) != null && ChainLinkEntity.canDestroyWith(stack)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        ChainKnotEntity knot = ChainKnotEntity.getKnotAt(world, blockPos);
        if (knot != null) {
            if (knot.method_5688(player, hand) == class_1269.field_21466) {
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        }
        List<ChainLink> attachableChains = ChainKnotEntity.getHeldChainsInRange(player, blockPos);
        ChainType knotType = ChainTypesRegistry.ITEM_CHAIN_TYPES.get(stack.method_7909());
        if (attachableChains.size() == 0 && knotType == null) {
            return class_1269.field_5811;
        }
        if (knotType == null) {
            knotType = attachableChains.get((int)0).chainType;
        }
        knot = new ChainKnotEntity(world, blockPos, knotType);
        knot.setGraceTicks((byte)0);
        world.method_8649((class_1297)knot);
        knot.method_6894();
        return knot.method_5688(player, hand);
    }
}

